/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver.strategy;

import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.resolver.data.Dependency;
import io.github.slimjar.resolver.data.Repository;
import io.github.slimjar.resolver.strategy.PathResolutionStrategy;
import java.util.Collection;
import java.util.Locale;
import java.util.stream.Collectors;

public final class MavenChecksumPathResolutionStrategy
implements PathResolutionStrategy {
    @NotNull
    private final PathResolutionStrategy resolutionStrategy;
    @NotNull
    private final String algorithm;

    @Contract(pure=true)
    public MavenChecksumPathResolutionStrategy(@NotNull String algorithm, @NotNull PathResolutionStrategy resolutionStrategy) {
        this.algorithm = algorithm.replaceAll("[ -]", "").toLowerCase(Locale.ENGLISH);
        this.resolutionStrategy = resolutionStrategy;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public @NotNull Collection<@NotNull String> pathTo(@NotNull Repository repository, @NotNull Dependency dependency) {
        return this.resolutionStrategy.pathTo(repository, dependency).stream().map(path -> path + "." + this.algorithm).collect(Collectors.toSet());
    }
}

