/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver.reader.resolution;

import io.github.slimjar.exceptions.ResolutionException;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.resolver.ResolutionResult;
import io.github.slimjar.util.Serialization;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@FunctionalInterface
public interface PreResolutionDataReader {
    public static final PreResolutionDataReader DEFAULT = inputStream -> {
        LinkedHashMap<String, ResolutionResult> linkedHashMap;
        DataInputStream in = new DataInputStream(inputStream);
        try {
            List<Map.Entry> list = Serialization.readList(in, din -> Map.entry(din.readUTF(), ResolutionResult.read(din)));
            LinkedHashMap<String, ResolutionResult> result = new LinkedHashMap<String, ResolutionResult>(list.size());
            for (Map.Entry entry : list) {
                result.put((String)entry.getKey(), (ResolutionResult)entry.getValue());
            }
            linkedHashMap = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ResolutionException("Failed to read dependency file", e);
            }
        }
        in.close();
        return linkedHashMap;
    };

    @NotNull
    public @NotNull Map<@NotNull String, @NotNull ResolutionResult> read(@NotNull InputStream var1) throws ReflectiveOperationException;
}

