/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver.reader.dependency;

import io.github.slimjar.exceptions.ResolutionException;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.libs.annotations.Nullable;
import io.github.slimjar.resolver.reader.dependency.DependencyDataProvider;
import io.github.slimjar.resolver.reader.dependency.DependencyDataProviderFactory;
import io.github.slimjar.resolver.reader.dependency.DependencyReader;
import io.github.slimjar.resolver.reader.dependency.EmptyDependencyDataProvider;
import io.github.slimjar.resolver.reader.dependency.URLDependencyDataProvider;
import java.net.URL;
import java.util.Objects;

public final class WrappingDependencyDataProviderFactory
implements DependencyDataProviderFactory {
    @NotNull
    private final DependencyReader reader;

    @Contract(pure=true)
    public WrappingDependencyDataProviderFactory(@NotNull DependencyReader reader) throws ResolutionException {
        this.reader = reader;
    }

    @Override
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public DependencyDataProvider create(@Nullable URL dependencyFileURL) {
        if (dependencyFileURL == null) {
            return new EmptyDependencyDataProvider();
        }
        return new URLDependencyDataProvider(this.reader, dependencyFileURL);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WrappingDependencyDataProviderFactory)) {
            return false;
        }
        WrappingDependencyDataProviderFactory that = (WrappingDependencyDataProviderFactory)obj;
        return Objects.equals(this.reader, that.reader);
    }

    public int hashCode() {
        return Objects.hash(this.reader);
    }

    public String toString() {
        return "WrappingDependencyDataProviderFactory[reader=" + String.valueOf(this.reader) + "]";
    }
}

