/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver.reader.dependency;

import io.github.slimjar.exceptions.ResolutionException;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.resolver.data.DependencyData;
import io.github.slimjar.resolver.reader.dependency.DependencyDataProvider;
import io.github.slimjar.resolver.reader.dependency.DependencyReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Objects;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public final class ModuleDependencyDataProvider
implements DependencyDataProvider {
    @NotNull
    private final DependencyReader dependencyReader;
    @NotNull
    private final URL moduleUrl;

    public ModuleDependencyDataProvider(@NotNull DependencyReader dependencyReader, @NotNull URL moduleUrl) {
        this.dependencyReader = dependencyReader;
        this.moduleUrl = moduleUrl;
    }

    @Override
    @NotNull
    public DependencyData get() {
        DependencyData dependencyData;
        block10: {
            URL depFileURL = this.getURL();
            URLConnection connection = depFileURL.openConnection();
            if (!(connection instanceof JarURLConnection)) {
                throw new AssertionError((Object)"Invalid Module URL provided(Non-Jar File)");
            }
            JarURLConnection jarURLConnection = (JarURLConnection)connection;
            JarFile jarFile = jarURLConnection.getJarFile();
            ZipEntry dependencyFileEntry = jarFile.getEntry("slimjar.dat");
            if (dependencyFileEntry == null) {
                return new DependencyData(Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
            }
            InputStream inputStream = jarFile.getInputStream(dependencyFileEntry);
            try {
                dependencyData = this.dependencyReader.read(inputStream);
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException err) {
                    throw new ResolutionException("Failed to get dependency data.", err);
                }
            }
            inputStream.close();
        }
        return dependencyData;
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public URL getURL() throws MalformedURLException {
        return new URL("jar:file:" + this.moduleUrl.getFile() + "!/slimjar.dat");
    }

    @NotNull
    public DependencyReader dependencyReader() {
        return this.dependencyReader;
    }

    @NotNull
    public URL moduleUrl() {
        return this.moduleUrl;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ModuleDependencyDataProvider that = (ModuleDependencyDataProvider)obj;
        return Objects.equals(this.dependencyReader, that.dependencyReader) && Objects.equals(this.moduleUrl, that.moduleUrl);
    }

    public int hashCode() {
        return Objects.hash(this.dependencyReader, this.moduleUrl);
    }

    public String toString() {
        return "ModuleDependencyDataProvider[dependencyReader=" + String.valueOf(this.dependencyReader) + ", moduleUrl=" + String.valueOf(this.moduleUrl) + "]";
    }
}

