/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver.reader.dependency;

import io.github.slimjar.exceptions.ResolutionException;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.libs.annotations.Nullable;
import io.github.slimjar.resolver.reader.dependency.DependencyDataProvider;
import io.github.slimjar.resolver.reader.dependency.DependencyDataProviderFactory;
import io.github.slimjar.resolver.reader.dependency.DependencyReader;
import io.github.slimjar.resolver.reader.dependency.EmptyDependencyDataProvider;
import io.github.slimjar.resolver.reader.dependency.ModuleDependencyDataProvider;
import java.net.URL;

public final class ExternalDependencyDataProviderFactory
implements DependencyDataProviderFactory {
    @NotNull
    private final DependencyReader reader;

    @Contract(pure=true)
    public ExternalDependencyDataProviderFactory(@NotNull DependencyReader reader) throws ResolutionException {
        this.reader = reader;
    }

    @Override
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public DependencyDataProvider create(@Nullable URL dependencyFileURL) {
        if (dependencyFileURL == null) {
            return new EmptyDependencyDataProvider();
        }
        return new ModuleDependencyDataProvider(this.reader, dependencyFileURL);
    }
}

