/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver.mirrors;

import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.logging.LocationAwareProcessLogger;
import io.github.slimjar.logging.ProcessLogger;
import io.github.slimjar.resolver.data.Mirror;
import io.github.slimjar.resolver.data.Repository;
import io.github.slimjar.resolver.mirrors.MirrorSelector;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Collectors;

public final class SimpleMirrorSelector
implements MirrorSelector {
    @NotNull
    private static final ProcessLogger LOGGER = LocationAwareProcessLogger.generic();

    @Override
    @Contract(pure=true)
    @NotNull
    public @NotNull Collection<@NotNull Repository> select(@NotNull @NotNull Collection<@NotNull Repository> mainRepositories, @NotNull @NotNull Collection<@NotNull Mirror> mirrors) {
        if (mainRepositories.isEmpty()) {
            return mainRepositories;
        }
        if (mirrors.isEmpty()) {
            return mainRepositories;
        }
        Map<String, String> repositoryMirrors = mirrors.stream().collect(Collectors.toMap(m -> m.original().toString(), m -> m.mirroring().toString(), (existing, replacement) -> {
            LOGGER.error("Duplicate mirror found '{}' and '{}'", existing, replacement);
            return existing;
        }));
        return mainRepositories.stream().distinct().map(original -> {
            String mirror;
            String url = original.url().toString();
            LinkedHashSet<String> visited = new LinkedHashSet<String>();
            while ((mirror = (String)repositoryMirrors.get(url)) != null) {
                if (!visited.add(url)) {
                    LOGGER.error("Circular mirror detected for '{}'", original.url());
                    break;
                }
                url = mirror;
            }
            try {
                return new Repository(URI.create(url).toURL());
            }
            catch (MalformedURLException e) {
                LOGGER.error("Failed to parse mirror URL '{}'", url);
                return original;
            }
        }).distinct().toList();
    }
}

