/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver.enquirer;

import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.libs.annotations.Nullable;
import io.github.slimjar.logging.LogDispatcher;
import io.github.slimjar.logging.ProcessLogger;
import io.github.slimjar.resolver.ResolutionResult;
import io.github.slimjar.resolver.data.Dependency;
import io.github.slimjar.resolver.data.Repository;
import io.github.slimjar.resolver.enquirer.RepositoryEnquirer;
import io.github.slimjar.resolver.pinger.URLPinger;
import io.github.slimjar.resolver.strategy.PathResolutionStrategy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;

public record PingingRepositoryEnquirer(@NotNull Repository repository, @NotNull PathResolutionStrategy dependencyURLCreationStrategy, @NotNull PathResolutionStrategy checksumURLCreationStrategy, @NotNull PathResolutionStrategy pomURLCreationStrategy, @NotNull URLPinger urlPinger) implements RepositoryEnquirer
{
    @NotNull
    private static final ProcessLogger LOGGER = LogDispatcher.getMediatingLogger();

    @Override
    @Contract(pure=true)
    @Nullable
    public ResolutionResult enquire(@NotNull Dependency dependency) {
        LOGGER.debug("Enquiring repositories to find %s", dependency);
        return this.dependencyURLCreationStrategy.pathTo(this.repository, dependency).stream().map(this::createURL).filter(Objects::nonNull).filter(this.urlPinger::ping).findFirst().map(url -> {
            URL resolvedChecksum = this.checksumURLCreationStrategy.pathTo(this.repository, dependency).parallelStream().map(this::createURL).filter(Objects::nonNull).filter(this.urlPinger::ping).findFirst().orElse(null);
            return new ResolutionResult(this.repository, (URL)url, resolvedChecksum, false, true);
        }).orElseGet(() -> this.pomURLCreationStrategy.pathTo(this.repository, dependency).parallelStream().map(this::createURL).filter(Objects::nonNull).filter(this.urlPinger::ping).findFirst().map(url -> new ResolutionResult(this.repository, (URL)url, null, true, false)).orElse(null));
    }

    @Override
    @NotNull
    public String toString() {
        return this.repository.url().toString();
    }

    @Contract(pure=true)
    @Nullable
    private URL createURL(@NotNull String path) {
        try {
            return new URL(this.repository.url(), path);
        }
        catch (MalformedURLException ignored) {
            LOGGER.error("Failed to create URL for %s", path);
            return null;
        }
    }
}

