/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver.data;

import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.libs.annotations.Nullable;
import io.github.slimjar.util.Serialization;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;

public record Repository(@NotNull URL url) {
    @NotNull
    public static final String CENTRAL_URL = "https://repo1.maven.org/maven2/";
    private static Repository centralInstance;

    @NotNull
    public static Repository central() {
        if (centralInstance == null) {
            try {
                centralInstance = new Repository(new URL(CENTRAL_URL));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return centralInstance;
    }

    public static Repository read(@NotNull DataInput in) throws IOException {
        return new Repository(Serialization.readURL(in));
    }

    public void write(@NotNull DataOutput out) throws IOException {
        Serialization.writeURL(this.url, out);
    }

    @Override
    @Contract(pure=true)
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Repository)) {
            return false;
        }
        Repository otherRepository = (Repository)o;
        return Objects.equals(this.url, otherRepository.url);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public String toString() {
        return "Repository{, url='" + String.valueOf(this.url) + "'}";
    }
}

