/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver.data;

import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.libs.annotations.Nullable;
import io.github.slimjar.util.Serialization;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Objects;

public record Mirror(@NotNull URL mirroring, @NotNull URL original) implements Serializable
{
    private static final long serialVersionUID = 1L;

    @NotNull
    @Contract(pure=true)
    public static Mirror read(@NotNull DataInput in) throws IOException {
        return new Mirror(Serialization.readURL(in), Serialization.readURL(in));
    }

    public void write(@NotNull DataOutput out) throws IOException {
        Serialization.writeURL(this.mirroring, out);
        Serialization.writeURL(this.original, out);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public String toString() {
        return "Mirror{mirroring=" + String.valueOf(this.mirroring) + ", original=" + String.valueOf(this.original) + "}";
    }

    @Override
    @Contract(value="null -> false", pure=true)
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Mirror)) {
            return false;
        }
        Mirror mirror = (Mirror)o;
        return Objects.equals(this.mirroring, mirror.mirroring) && Objects.equals(this.original, mirror.original);
    }
}

