/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver.data;

import io.github.slimjar.exceptions.NotComparableDependencyException;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.libs.annotations.Nullable;
import io.github.slimjar.util.Serialization;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

public record Dependency(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @Nullable String snapshotId, @NotNull Collection<Dependency> transitive) implements Comparable<Dependency>
{
    @NotNull
    @Contract(pure=true)
    public static Dependency read(@NotNull DataInput in) throws IOException {
        return new Dependency(in.readUTF(), in.readUTF(), in.readUTF(), in.readBoolean() ? in.readUTF() : null, Serialization.readList(in, Dependency::read));
    }

    public boolean isSnapshot() {
        return this.snapshotId != null && !this.snapshotId.isEmpty();
    }

    public Optional<String> snapshot() {
        return this.isSnapshot() ? Optional.ofNullable(this.snapshotId) : Optional.empty();
    }

    public void write(@NotNull DataOutput out) throws IOException {
        out.writeUTF(this.groupId);
        out.writeUTF(this.artifactId);
        out.writeUTF(this.version);
        if (this.snapshotId == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.snapshotId);
        }
        Serialization.writeList(this.transitive, out, Dependency::write);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public String toString() {
        String suffix = this.isSnapshot() ? ":" + this.snapshotId() : "";
        return this.groupId() + ":" + this.artifactId() + ":" + this.version() + suffix;
    }

    @Override
    @Contract(value="null -> false", pure=true)
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Dependency)) {
            return false;
        }
        Dependency otherDependency = (Dependency)o;
        return this.groupId.equals(otherDependency.groupId) && this.artifactId.equals(otherDependency.artifactId) && this.version.equals(otherDependency.version);
    }

    @Override
    @Contract(pure=true)
    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version);
    }

    @Override
    @Contract(pure=true)
    public int compareTo(@NotNull Dependency o) throws NotComparableDependencyException {
        if (!this.equals(o)) {
            throw new NotComparableDependencyException(this, o);
        }
        return this.version().compareTo(o.version());
    }
}

