/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver;

import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.libs.annotations.Nullable;
import io.github.slimjar.resolver.data.Repository;
import io.github.slimjar.util.Serialization;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;

public final class ResolutionResult {
    @NotNull
    private final Repository repository;
    @NotNull
    private final URL dependencyURL;
    @Nullable
    private final URL checksumURL;
    private final boolean aggregator;
    private transient boolean checked;

    @Contract(pure=true)
    public ResolutionResult(@NotNull Repository repository, @NotNull URL dependencyURL, @Nullable URL checksumURL, boolean aggregator, boolean checked) {
        this.repository = repository;
        this.dependencyURL = dependencyURL;
        this.checksumURL = checksumURL;
        this.aggregator = aggregator;
        this.checked = checked;
        if (!aggregator) {
            Objects.requireNonNull(dependencyURL, "Resolved URL must not be null for non-aggregator dependencies");
        }
    }

    @NotNull
    @Contract(pure=true)
    public static ResolutionResult read(@NotNull DataInput in) throws IOException {
        return new ResolutionResult(Repository.read(in), Serialization.readURL(in), in.readBoolean() ? Serialization.readURL(in) : null, in.readBoolean(), false);
    }

    public void write(@NotNull DataOutput out) throws IOException {
        this.repository.write(out);
        Serialization.writeURL(this.dependencyURL, out);
        if (this.checksumURL == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Serialization.writeURL(this.checksumURL, out);
        }
        out.writeBoolean(this.aggregator);
    }

    @NotNull
    public Repository repository() {
        return this.repository;
    }

    @NotNull
    public URL dependencyURL() {
        return this.dependencyURL;
    }

    @Nullable
    public URL checksumURL() {
        return this.checksumURL;
    }

    public boolean aggregator() {
        return this.aggregator;
    }

    public boolean checked() {
        return this.checked;
    }

    public void setChecked() {
        this.checked = true;
    }

    @Contract(pure=true)
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResolutionResult)) {
            return false;
        }
        ResolutionResult otherResult = (ResolutionResult)o;
        return Objects.equals(this.dependencyURL.toString(), otherResult.dependencyURL.toString()) && Objects.equals(this.checksumURL != null ? this.checksumURL.toString() : null, otherResult.checksumURL != null ? otherResult.checksumURL.toString() : null) && this.aggregator == otherResult.aggregator && this.checked == otherResult.checked;
    }

    @Contract(pure=true)
    public int hashCode() {
        return Objects.hash(this.dependencyURL.toString(), this.checksumURL != null ? this.checksumURL.toString() : null, this.aggregator, this.checked);
    }
}

