/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver;

import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.libs.annotations.Nullable;
import io.github.slimjar.logging.LogDispatcher;
import io.github.slimjar.logging.ProcessLogger;
import io.github.slimjar.resolver.DependencyResolver;
import io.github.slimjar.resolver.ResolutionResult;
import io.github.slimjar.resolver.data.Dependency;
import io.github.slimjar.resolver.data.Repository;
import io.github.slimjar.resolver.enquirer.RepositoryEnquirer;
import io.github.slimjar.resolver.enquirer.RepositoryEnquirerFactory;
import io.github.slimjar.resolver.pinger.URLPinger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinTask;

public final class CachingDependencyResolver
implements DependencyResolver {
    @NotNull
    private static final ProcessLogger LOGGER = LogDispatcher.getMediatingLogger();
    @NotNull
    private final URLPinger urlPinger;
    @NotNull
    private final @NotNull List<@NotNull RepositoryEnquirer> repositories;
    @NotNull
    private final Map<Dependency, ResolutionResult> cachedResults = new ConcurrentHashMap<Dependency, ResolutionResult>();
    @NotNull
    private final Map<String, ResolutionResult> preResolvedResults;

    @Contract(pure=true)
    public CachingDependencyResolver(@NotNull URLPinger urlPinger, @NotNull @NotNull Collection<@NotNull Repository> repositories, @NotNull RepositoryEnquirerFactory enquirerFactory, @NotNull Map<String, ResolutionResult> preResolvedResults) {
        this.urlPinger = urlPinger;
        this.preResolvedResults = new ConcurrentHashMap<String, ResolutionResult>(preResolvedResults);
        this.repositories = repositories.stream().map(enquirerFactory::create).distinct().toList();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Optional<ResolutionResult> resolve(@NotNull Dependency dependency) {
        return this.resolve(dependency, Collections.emptyList());
    }

    @Contract(pure=true)
    @NotNull
    public Optional<ResolutionResult> resolve(@NotNull Dependency dependency, @NotNull List<RepositoryEnquirer> enforcedRepositories) {
        return Optional.ofNullable(this.cachedResults.computeIfAbsent(dependency, dep -> this.attemptResolve((Dependency)dep, enforcedRepositories)));
    }

    @Contract(pure=true)
    @Nullable
    private ResolutionResult attemptResolve(@NotNull Dependency dependency, @NotNull List<RepositoryEnquirer> enforcedRepositories) {
        ResolutionResult preResolvedResult;
        ResolutionResult resolutionResult = preResolvedResult = this.preResolvedResults.get(dependency.toString()) != null ? this.preResolvedResults.get(dependency.toString()) : this.cachedResults.get(dependency);
        if (preResolvedResult != null) {
            boolean isChecksumValid;
            if (preResolvedResult.checked()) {
                return preResolvedResult;
            }
            if (preResolvedResult.aggregator()) {
                return preResolvedResult;
            }
            String preResolvedUrl = preResolvedResult.repository().url().toString();
            boolean isDependencyValid = (enforcedRepositories.isEmpty() || enforcedRepositories.stream().anyMatch(repo -> repo.toString().equals(preResolvedUrl))) && this.urlPinger.ping(preResolvedResult.dependencyURL());
            boolean bl = isChecksumValid = preResolvedResult.checksumURL() == null || this.urlPinger.ping(preResolvedResult.checksumURL());
            if (isDependencyValid && isChecksumValid) {
                preResolvedResult.setChecked();
                return preResolvedResult;
            }
        }
        List<RepositoryEnquirer> usedRepositories = enforcedRepositories.isEmpty() ? this.repositories : enforcedRepositories;
        ArrayList<ForkJoinTask<ResolutionResult>> futures = new ArrayList<ForkJoinTask<ResolutionResult>>(usedRepositories.size());
        for (RepositoryEnquirer repositoryEnquirer : usedRepositories) {
            futures.add(ForkJoinTask.adapt(() -> enquirer.enquire(dependency)).fork());
        }
        for (ForkJoinTask forkJoinTask : futures) {
            ResolutionResult result = (ResolutionResult)forkJoinTask.join();
            if (result == null) continue;
            LOGGER.debug("Resolved %s @ %s", dependency, result.dependencyURL());
            return result;
        }
        LOGGER.debug("Resolved %s @ [FAILED TO RESOLVE]", dependency);
        return null;
    }
}

