/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.relocation.meta;

import io.github.slimjar.exceptions.RelocatorException;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.relocation.meta.FlatFileMetaMediator;
import io.github.slimjar.relocation.meta.MetaMediator;
import io.github.slimjar.relocation.meta.MetaMediatorFactory;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class FlatFileMetaMediatorFactory
implements MetaMediatorFactory {
    @Override
    @Contract(value="_ -> new")
    @NotNull
    public MetaMediator create(@NotNull Path path) throws RelocatorException {
        Path metaPath = path.getParent().resolve(path.getFileName().toString() + ".slimjar_meta");
        if (Files.exists(metaPath, new LinkOption[0])) {
            return new FlatFileMetaMediator(metaPath);
        }
        try {
            Files.createDirectories(metaPath, new FileAttribute[0]);
        }
        catch (IOException err) {
            throw new RelocatorException("Failed to create new file.", err);
        }
        return new FlatFileMetaMediator(metaPath);
    }
}

