/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.relocation.meta;

import io.github.slimjar.exceptions.RelocatorException;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.libs.annotations.Nullable;
import io.github.slimjar.relocation.meta.MetaMediator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class FlatFileMetaMediator
implements MetaMediator {
    @NotNull
    private final Path metaFolderPath;

    public FlatFileMetaMediator(@NotNull Path metaFolderPath) {
        this.metaFolderPath = metaFolderPath;
    }

    @Override
    @Nullable
    public String readAttribute(@NotNull String name) throws RelocatorException {
        Path attributeFile = this.metaFolderPath.resolve(name);
        if (Files.notExists(attributeFile, new LinkOption[0]) || Files.isDirectory(attributeFile, new LinkOption[0])) {
            return null;
        }
        try {
            return Files.readString(attributeFile);
        }
        catch (IOException err) {
            throw new RelocatorException("Failed to read attribute " + name, err);
        }
    }

    @Override
    public void writeAttribute(@NotNull String name, @NotNull String value) throws RelocatorException {
        Path attributeFile = this.metaFolderPath.resolve(name);
        try {
            Files.deleteIfExists(attributeFile);
            Files.createFile(attributeFile, new FileAttribute[0]);
            Files.write(attributeFile, value.getBytes(), new OpenOption[0]);
        }
        catch (IOException err) {
            throw new RelocatorException("Failed to write attribute " + name, err);
        }
    }
}

