/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.relocation.helper;

import io.github.slimjar.downloader.strategy.FilePathStrategy;
import io.github.slimjar.downloader.verify.FileChecksumCalculator;
import io.github.slimjar.exceptions.RelocatorException;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.relocation.Relocator;
import io.github.slimjar.relocation.helper.RelocationHelper;
import io.github.slimjar.relocation.helper.RelocationHelperFactory;
import io.github.slimjar.relocation.helper.VerifyingRelocationHelper;
import io.github.slimjar.relocation.meta.MetaMediatorFactory;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

public final class VerifyingRelocationHelperFactory
implements RelocationHelperFactory {
    @NotNull
    private static final URI JAR_URL;
    @NotNull
    private final FilePathStrategy relocationFilePathStrategy;
    @NotNull
    private final MetaMediatorFactory mediatorFactory;
    @NotNull
    private final String selfHash;

    public VerifyingRelocationHelperFactory(@NotNull String selfHash, @NotNull FilePathStrategy relocationFilePathStrategy, @NotNull MetaMediatorFactory mediatorFactory) {
        this.relocationFilePathStrategy = relocationFilePathStrategy;
        this.mediatorFactory = mediatorFactory;
        this.selfHash = selfHash;
    }

    public VerifyingRelocationHelperFactory(@NotNull FileChecksumCalculator calculator, @NotNull FilePathStrategy relocationFilePathStrategy, @NotNull MetaMediatorFactory mediatorFactory) {
        this(calculator.calculate(new File(JAR_URL)), relocationFilePathStrategy, mediatorFactory);
    }

    @Override
    @Contract(value="_ -> new")
    @NotNull
    public RelocationHelper create(@NotNull Relocator relocator) {
        return new VerifyingRelocationHelper(this.selfHash, this.relocationFilePathStrategy, relocator, this.mediatorFactory);
    }

    static {
        try {
            JAR_URL = VerifyingRelocationHelperFactory.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException err) {
            throw new RelocatorException("Failed to convert URL to URI.", err);
        }
    }
}

