/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.relocation.helper;

import io.github.slimjar.downloader.strategy.FilePathStrategy;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.relocation.Relocator;
import io.github.slimjar.relocation.helper.RelocationHelper;
import io.github.slimjar.relocation.meta.MetaMediator;
import io.github.slimjar.relocation.meta.MetaMediatorFactory;
import io.github.slimjar.resolver.data.Dependency;
import java.io.File;

public final class VerifyingRelocationHelper
implements RelocationHelper {
    @NotNull
    private final FilePathStrategy outputFilePathStrategy;
    @NotNull
    private final Relocator relocator;
    @NotNull
    private final String selfHash;
    @NotNull
    private final MetaMediatorFactory mediatorFactory;

    public VerifyingRelocationHelper(@NotNull String selfHash, @NotNull FilePathStrategy outputFilePathStrategy, @NotNull Relocator relocator, @NotNull MetaMediatorFactory mediatorFactory) {
        this.mediatorFactory = mediatorFactory;
        this.outputFilePathStrategy = outputFilePathStrategy;
        this.relocator = relocator;
        this.selfHash = selfHash;
    }

    @Override
    @NotNull
    public File relocate(@NotNull Dependency dependency, @NotNull File file) {
        String ownerHash;
        File relocatedFile = this.outputFilePathStrategy.selectFileFor(dependency);
        MetaMediator metaMediator = this.mediatorFactory.create(relocatedFile.toPath());
        if (relocatedFile.exists() && (ownerHash = metaMediator.readAttribute("slimjar.owner")) != null && this.selfHash.trim().equals(ownerHash.trim())) {
            return relocatedFile;
        }
        this.relocator.relocate(file, relocatedFile);
        metaMediator.writeAttribute("slimjar.owner", this.selfHash);
        return relocatedFile;
    }
}

