/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.relocation;

import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.libs.annotations.Nullable;
import io.github.slimjar.util.Serialization;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public record RelocationRule(@NotNull String originalPackagePattern, @NotNull String relocatedPackagePattern, @NotNull Collection<String> exclusions, @NotNull Collection<String> inclusions) implements Serializable
{
    private static final long serialVersionUID = 1L;

    public RelocationRule(@NotNull String original, @NotNull String relocated) {
        this(original, relocated, Collections.emptyList(), Collections.emptyList());
    }

    @NotNull
    @Contract(pure=true)
    public static RelocationRule read(@NotNull DataInput in) throws IOException {
        return new RelocationRule(in.readUTF(), in.readUTF(), Serialization.readList(in, DataInput::readUTF), Serialization.readList(in, DataInput::readUTF));
    }

    public void write(@NotNull DataOutput out) throws IOException {
        out.writeUTF(this.originalPackagePattern);
        out.writeUTF(this.relocatedPackagePattern);
        Serialization.writeList(this.exclusions, out, (pattern, o) -> o.writeUTF((String)pattern));
        Serialization.writeList(this.inclusions, out, (pattern, o) -> o.writeUTF((String)pattern));
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RelocationRule)) {
            return false;
        }
        RelocationRule that = (RelocationRule)o;
        return this.originalPackagePattern.equals(that.originalPackagePattern) && this.relocatedPackagePattern.equals(that.relocatedPackagePattern);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.originalPackagePattern, this.relocatedPackagePattern);
    }

    @Override
    @NotNull
    public String toString() {
        return "RelocationRule{originalPackagePattern='" + this.originalPackagePattern + "', relocatedPackagePattern='" + this.relocatedPackagePattern + "'}";
    }
}

