/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.logging;

import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.logging.ProcessLogger;
import java.util.Collection;

public final class MediatingProcessLogger
implements ProcessLogger {
    @NotNull
    private final @NotNull Collection<@NotNull ProcessLogger> loggers;

    @Contract(pure=true)
    public MediatingProcessLogger(@NotNull @NotNull Collection<@NotNull ProcessLogger> loggers) {
        this.loggers = loggers;
    }

    @Override
    public void info(@NotNull String message, Object ... args) {
        this.loggers.forEach(logger -> logger.info(message, args));
    }

    @Override
    public void debug(@NotNull String message, Object ... args) {
        this.loggers.forEach(logger -> logger.debug(message, args));
    }

    @Override
    public void error(@NotNull String message, Object ... args) {
        this.loggers.forEach(logger -> logger.error(message, args));
    }

    @Contract(pure=true)
    public void addLogger(@NotNull ProcessLogger logger) {
        this.loggers.add(logger);
    }

    @Contract(pure=true)
    public void removeLogger(@NotNull ProcessLogger logger) {
        this.loggers.remove(logger);
    }

    @Contract(pure=true)
    public void clearLoggers() {
        this.loggers.clear();
    }
}

