/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.logging;

import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.logging.LogDispatcher;
import io.github.slimjar.logging.ProcessLogger;

public final class LocationAwareProcessLogger
implements ProcessLogger {
    @NotNull
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    @NotNull
    private final ProcessLogger logger;
    @NotNull
    private final Class<?> location;

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ProcessLogger wrapping(@NotNull ProcessLogger logger) {
        return new LocationAwareProcessLogger(logger, STACK_WALKER.getCallerClass());
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static ProcessLogger generic() {
        return new LocationAwareProcessLogger(LogDispatcher.getMediatingLogger(), STACK_WALKER.getCallerClass());
    }

    @Contract(pure=true)
    private LocationAwareProcessLogger(@NotNull ProcessLogger logger, @NotNull Class<?> location) {
        this.logger = logger;
        this.location = location;
    }

    @Override
    public void info(@NotNull String message, Object ... args) {
        this.logger.info(this.formatMessage(message), args);
    }

    @Override
    public void error(@NotNull String message, Object ... args) {
        this.logger.error(this.formatMessage(message), args);
    }

    @Override
    public void debug(@NotNull String message, Object ... args) {
        this.logger.debug(this.formatMessage(message), args);
    }

    @Contract(pure=true)
    @NotNull
    private String formatMessage(@NotNull String message) {
        return String.format("[%s] %s", this.location.getSimpleName(), message);
    }
}

