/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.injector.loader.manifest;

import io.github.slimjar.exceptions.InjectorException;
import io.github.slimjar.injector.loader.manifest.ManifestGenerator;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;

public final class JarManifestGenerator
implements ManifestGenerator {
    @NotNull
    private final Map<String, String> attributes = new HashMap<String, String>();
    @NotNull
    private final URI jarURI;

    @Contract(pure=true)
    public JarManifestGenerator(@NotNull URI jarURI) {
        this.jarURI = jarURI;
    }

    @Override
    @Contract(value="_, _ -> this", mutates="this")
    @NotNull
    public ManifestGenerator attribute(@NotNull String key, @NotNull String value) {
        this.attributes.put(key, value);
        return this;
    }

    @Override
    public void generate() throws InjectorException {
        Map<String, String> env = Map.of("create", "true");
        URI uri = URI.create(String.format("jar:%s", this.jarURI));
        try (FileSystem fs = FileSystems.newFileSystem(uri, env);){
            Path nf = fs.getPath("META-INF/MANIFEST.MF", new String[0]);
            Files.createDirectories(nf.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(nf, StandardCharsets.UTF_8, StandardOpenOption.CREATE);){
                for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                    writer.write(String.format("%s: %s%n", entry.getKey(), entry.getValue()));
                }
            }
        }
        catch (IOException err) {
            throw new InjectorException("Failed to generate manifest.", err);
        }
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ManifestGenerator with(@NotNull URI uri) {
        return new JarManifestGenerator(uri);
    }
}

