/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.injector.loader;

import io.github.slimjar.exceptions.InjectorException;
import io.github.slimjar.injector.loader.Injectable;
import io.github.slimjar.libs.annotations.NotNull;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public final class WrappedInjectableClassLoader
implements Injectable {
    @NotNull
    private final URLClassLoader urlClassLoader;
    @NotNull
    private final Method addURLMethod;

    public WrappedInjectableClassLoader(@NotNull URLClassLoader urlClassLoader) throws ReflectiveOperationException {
        this.urlClassLoader = urlClassLoader;
        this.addURLMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        this.addURLMethod.setAccessible(true);
    }

    @Override
    public void inject(@NotNull URL url) throws InjectorException {
        try {
            this.addURLMethod.invoke((Object)this.urlClassLoader, url);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new InjectorException("Unable to invoke addURL method", e);
        }
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }
}

