/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.injector.loader;

import io.github.slimjar.exceptions.InjectorException;
import io.github.slimjar.injector.loader.Injectable;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import sun.misc.Unsafe;

public final class UnsafeInjectable
implements Injectable {
    @NotNull
    private final ArrayDeque<URL> unopenedURLs;
    @NotNull
    private final ArrayList<URL> pathURLs;

    public UnsafeInjectable(@NotNull ArrayDeque<URL> unopenedURLs, @NotNull ArrayList<URL> pathURLs) {
        this.unopenedURLs = unopenedURLs;
        this.pathURLs = pathURLs;
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inject(@NotNull URL url) throws InjectorException {
        ArrayDeque<URL> arrayDeque = this.unopenedURLs;
        synchronized (arrayDeque) {
            if (!this.pathURLs.contains(url)) {
                this.unopenedURLs.addLast(url);
                this.pathURLs.add(url);
            }
        }
    }

    @Contract(value="_ -> new")
    public static Injectable create(ClassLoader classLoader) throws ReflectiveOperationException {
        Field field = Unsafe.class.getDeclaredField("theUnsafe");
        field.setAccessible(true);
        Unsafe unsafe = (Unsafe)field.get(null);
        Field lookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
        MethodHandles.Lookup lookup = (MethodHandles.Lookup)unsafe.getObject(unsafe.staticFieldBase(lookupField), unsafe.staticFieldOffset(lookupField));
        try {
            Object ucp = lookup.findGetter(classLoader.getClass(), "ucp", lookup.findClass("jdk.internal.loader.URLClassPath")).invoke(classLoader);
            return new UnsafeInjectable((ArrayDeque)UnsafeInjectable.fetchField(unsafe, ucp, "unopenedUrls"), (ArrayList)UnsafeInjectable.fetchField(unsafe, ucp, "path"));
        }
        catch (Throwable e) {
            if (e instanceof ReflectiveOperationException) {
                ReflectiveOperationException ex = (ReflectiveOperationException)e;
                throw ex;
            }
            throw new InvocationTargetException(e);
        }
    }

    private static Object fetchField(Unsafe unsafe, Object object, String name) throws NoSuchFieldException {
        return UnsafeInjectable.fetchField(unsafe, object.getClass(), object, name);
    }

    @NotNull
    private static Object fetchField(@NotNull Unsafe unsafe, @NotNull Class<?> clazz, @NotNull Object object, @NotNull String name) throws NoSuchFieldException {
        Field field = clazz.getDeclaredField(name);
        long offset = unsafe.objectFieldOffset(field);
        return unsafe.getObject(object, offset);
    }
}

