/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.injector.loader;

import io.github.slimjar.injector.loader.InjectableClassLoader;
import io.github.slimjar.libs.annotations.NotNull;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class IsolatedInjectableClassLoader
extends InjectableClassLoader {
    @NotNull
    private final Map<String, Class<?>> delegatesMap = new HashMap();

    public IsolatedInjectableClassLoader() {
        this(new URL[0]);
    }

    public IsolatedInjectableClassLoader(URL ... urls) {
        this(urls, Collections.emptySet());
    }

    public IsolatedInjectableClassLoader(@NotNull URL[] urls, @NotNull Collection<Class<?>> delegates) {
        this(urls, delegates, IsolatedInjectableClassLoader.getSystemClassLoader().getParent());
    }

    public IsolatedInjectableClassLoader(@NotNull URL[] urls, @NotNull Collection<Class<?>> delegates, @NotNull ClassLoader parent) {
        super(urls, parent);
        delegates.forEach(delegate -> this.delegatesMap.put(delegate.getName(), (Class<?>)delegate));
    }

    @Override
    protected Class<?> loadClass(@NotNull String name, boolean resolve) throws ClassNotFoundException {
        Class<?> loaded = this.findLoadedClass(name);
        if (loaded != null) {
            return loaded;
        }
        Class<?> delegate = this.delegatesMap.get(name);
        if (delegate != null) {
            return delegate;
        }
        return super.loadClass(name, resolve);
    }

    static {
        IsolatedInjectableClassLoader.registerAsParallelCapable();
    }
}

