/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.injector.loader;

import io.github.slimjar.exceptions.InjectorException;
import io.github.slimjar.injector.loader.Injectable;
import io.github.slimjar.injector.loader.InstrumentationInjectable;
import io.github.slimjar.injector.loader.UnsafeInjectable;
import io.github.slimjar.injector.loader.WrappedInjectableClassLoader;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.resolver.data.Repository;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Collection;

public final class InjectableFactory {
    private InjectableFactory() {
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static Injectable create(@NotNull Path downloadPath, @NotNull Collection<Repository> repositories) throws InjectorException {
        return InjectableFactory.create(downloadPath, repositories, InjectableFactory.class.getClassLoader());
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static Injectable create(@NotNull Path downloadPath, @NotNull Collection<Repository> repositories, @NotNull ClassLoader classLoader) throws InjectorException {
        while (classLoader != null) {
            if (classLoader instanceof Injectable) {
                Injectable injectable = (Injectable)((Object)classLoader);
                return injectable;
            }
            try {
                if (classLoader instanceof URLClassLoader) {
                    URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
                    return new WrappedInjectableClassLoader(urlClassLoader);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                return UnsafeInjectable.create(classLoader);
            }
            catch (Throwable throwable) {
                classLoader = classLoader.getParent();
            }
        }
        return InstrumentationInjectable.create(downloadPath, repositories);
    }
}

