/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.injector.helper;

import io.github.slimjar.downloader.DependencyDownloader;
import io.github.slimjar.exceptions.InjectorException;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.relocation.helper.RelocationHelper;
import io.github.slimjar.resolver.data.Dependency;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public final class DownloadHelper {
    private final ConcurrentHashMap.KeySetView<Dependency, Boolean> downloadedDependencies;
    private final DependencyDownloader dependencyDownloader;
    private final RelocationHelper relocationHelper;

    public DownloadHelper(DependencyDownloader dependencyDownloader, RelocationHelper relocationHelper) {
        this.dependencyDownloader = dependencyDownloader;
        this.relocationHelper = relocationHelper;
        this.downloadedDependencies = ConcurrentHashMap.newKeySet();
    }

    @NotNull
    public @NotNull Stream<@NotNull File> fetch(@NotNull Collection<Dependency> dependencies) throws InjectorException {
        return dependencies.parallelStream().filter(this.downloadedDependencies::add).flatMap(dependency -> Stream.concat(this.fetch(dependency.transitive()), this.dependencyDownloader.download((Dependency)dependency).map(file -> this.relocationHelper.relocate((Dependency)dependency, (File)file)).stream()));
    }
}

