/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.injector;

import io.github.slimjar.exceptions.InjectorException;
import io.github.slimjar.injector.DependencyInjector;
import io.github.slimjar.injector.helper.DownloadHelper;
import io.github.slimjar.injector.helper.DownloadHelperFactory;
import io.github.slimjar.injector.loader.Injectable;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.logging.LogDispatcher;
import io.github.slimjar.logging.ProcessLogger;
import io.github.slimjar.resolver.ResolutionResult;
import io.github.slimjar.resolver.data.Dependency;
import io.github.slimjar.resolver.data.DependencyData;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;

public final class SimpleDependencyInjector
implements DependencyInjector {
    private static final ProcessLogger LOGGER = LogDispatcher.getMediatingLogger();
    private final DownloadHelperFactory downloadHelperFactory;

    public SimpleDependencyInjector(DownloadHelperFactory downloadHelperFactory) {
        this.downloadHelperFactory = downloadHelperFactory;
    }

    @Override
    public void inject(@NotNull Injectable injectable, @NotNull DependencyData data, @NotNull Map<String, ResolutionResult> preResolvedResults) {
        DownloadHelper helper = this.downloadHelperFactory.create(data, preResolvedResults);
        this.injectDependencies(injectable, helper, data.dependencies());
    }

    private void injectDependencies(@NotNull Injectable injectable, @NotNull DownloadHelper downloadHelper, @NotNull Collection<Dependency> dependencies) throws InjectorException {
        Consumer<File> action = file -> {
            try {
                injectable.inject(file.toURI().toURL());
                LOGGER.info("Loaded library %s", file.toPath().normalize());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        };
        Stream<File> stream = downloadHelper.fetch(dependencies);
        if (injectable.isThreadSafe()) {
            stream.forEach(action);
        } else {
            stream.toList().forEach(action);
        }
    }
}

