/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.exceptions;

import io.github.slimjar.exceptions.DownloaderException;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.resolver.data.Dependency;

public final class UnresolvedDependencyException
extends DownloaderException {
    @NotNull
    private final transient Dependency dependency;

    @Contract(pure=true)
    public UnresolvedDependencyException(@NotNull Dependency dependency) {
        super("Could not resolve dependency : " + String.valueOf(dependency));
        this.dependency = dependency;
    }

    @Contract(pure=true)
    @NotNull
    public Dependency dependency() {
        return this.dependency;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public String toString() {
        return String.format("UnresolvedDependencyException{dependency=%s}", this.dependency);
    }
}

