/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.exceptions;

import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class SlimJarException
extends RuntimeException {
    @Contract(pure=true)
    public SlimJarException(@NotNull String message) {
        super(message);
    }

    @Contract(pure=true)
    public SlimJarException(@NotNull String message, @NotNull Throwable cause) {
        super(message);
        if (!(cause instanceof SlimJarException)) {
            return;
        }
        this.addSuppressed(cause);
        this.initCause(cause);
    }

    public void checkInterrupted() {
        if (!(this.getCause() instanceof InterruptedException)) {
            return;
        }
        Thread.currentThread().interrupt();
    }
}

