/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.downloader.strategy;

import io.github.slimjar.downloader.strategy.FilePathStrategy;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.logging.LocationAwareProcessLogger;
import io.github.slimjar.logging.ProcessLogger;
import io.github.slimjar.resolver.data.Dependency;
import java.io.File;

public final class FolderedFilePathStrategy
implements FilePathStrategy {
    @NotNull
    private static final ProcessLogger LOGGER = LocationAwareProcessLogger.generic();
    @NotNull
    private static final String DEPENDENCY_FILE_FORMAT = "%s/%s/%s/%s/%3$s-%4$s.jar";
    @NotNull
    private final File rootDirectory;

    @Contract(pure=true)
    private FolderedFilePathStrategy(@NotNull File rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public File selectFileFor(@NotNull Dependency dependency) {
        String extendedVersion = dependency.snapshot().map(s -> "-" + s).orElse("");
        String path = String.format(DEPENDENCY_FILE_FORMAT, this.rootDirectory.getPath(), dependency.groupId().replace('.', '/'), dependency.artifactId(), dependency.version() + extendedVersion);
        LOGGER.debug("Selected jar file for %s at %s.", dependency, path);
        return new File(path);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static FilePathStrategy createStrategy(@NotNull File rootDirectory) throws IllegalStateException {
        FilePathStrategy.validateDirectory(rootDirectory);
        return new FolderedFilePathStrategy(rootDirectory);
    }
}

