/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.downloader.strategy;

import io.github.slimjar.downloader.strategy.FilePathStrategy;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.logging.LocationAwareProcessLogger;
import io.github.slimjar.logging.ProcessLogger;
import io.github.slimjar.resolver.data.Dependency;
import java.io.File;
import java.util.Locale;

public final class ChecksumFilePathStrategy
implements FilePathStrategy {
    @NotNull
    private static final ProcessLogger LOGGER = LocationAwareProcessLogger.generic();
    @NotNull
    private static final String DEPENDENCY_FILE_FORMAT = "%s/%s/%s/%s/%3$s-%4$s.jar.%5$s";
    @NotNull
    private final File rootDirectory;
    @NotNull
    private final String algorithm;

    @Contract(pure=true)
    private ChecksumFilePathStrategy(@NotNull File rootDirectory, @NotNull String algorithm) {
        this.rootDirectory = rootDirectory;
        this.algorithm = algorithm.replaceAll("[ -]", "").toLowerCase(Locale.ENGLISH);
    }

    @Override
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public File selectFileFor(@NotNull Dependency dependency) {
        String extendedVersion = dependency.snapshot().map(s -> "-" + s).orElse("");
        String path = DEPENDENCY_FILE_FORMAT.formatted(this.rootDirectory.getPath(), dependency.groupId().replace('.', '/'), dependency.artifactId(), dependency.version() + extendedVersion, this.algorithm);
        LOGGER.debug("Selected checksum file for %s at %s", dependency, path);
        return new File(path);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static FilePathStrategy createStrategy(@NotNull File rootDirectory, @NotNull String algorithm) throws IllegalStateException {
        FilePathStrategy.validateDirectory(rootDirectory);
        return new ChecksumFilePathStrategy(rootDirectory, algorithm);
    }
}

