/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.downloader.output;

import io.github.slimjar.downloader.output.ChanneledFileOutputWriter;
import io.github.slimjar.downloader.output.OutputWriter;
import io.github.slimjar.downloader.output.OutputWriterFactory;
import io.github.slimjar.downloader.strategy.FilePathStrategy;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.logging.LocationAwareProcessLogger;
import io.github.slimjar.logging.ProcessLogger;
import io.github.slimjar.resolver.data.Dependency;
import java.io.File;

public final class DependencyOutputWriterFactory
implements OutputWriterFactory {
    @NotNull
    private static final ProcessLogger LOGGER = LocationAwareProcessLogger.generic();
    @NotNull
    private final FilePathStrategy outputFilePathStrategy;

    @Contract(pure=true)
    public DependencyOutputWriterFactory(@NotNull FilePathStrategy filePathStrategy) {
        this.outputFilePathStrategy = filePathStrategy;
    }

    @Override
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public OutputWriter create(@NotNull Dependency dependency) {
        LOGGER.debug("Creating OutputWriter for %s", dependency);
        File outputFile = this.outputFilePathStrategy.selectFileFor(dependency);
        outputFile.getParentFile().mkdirs();
        return new ChanneledFileOutputWriter(outputFile);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public FilePathStrategy getStrategy() {
        return this.outputFilePathStrategy;
    }
}

