/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.downloader.output;

import io.github.slimjar.downloader.output.OutputWriter;
import io.github.slimjar.exceptions.OutputWriterException;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.logging.LocationAwareProcessLogger;
import io.github.slimjar.logging.ProcessLogger;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;

public final class ChanneledFileOutputWriter
implements OutputWriter {
    @NotNull
    private static final ProcessLogger LOGGER = LocationAwareProcessLogger.generic();
    @NotNull
    private final File outputFile;

    @Contract(pure=true)
    public ChanneledFileOutputWriter(@NotNull File outputFile) {
        this.outputFile = outputFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Contract(mutates="param1")
    @NotNull
    public File writeFrom(@NotNull InputStream inputStream, long length) throws OutputWriterException {
        LOGGER.debug("Attempting to write from inputStream...", new Object[0]);
        try (InputStream inputStream2 = inputStream;){
            if (this.outputFile.exists()) {
                File file = this.outputFile;
                return file;
            }
            LOGGER.debug("Writing %s bytes...", length == -1L ? "unknown" : Long.valueOf(length));
            Files.copy(inputStream, this.outputFile.toPath(), new CopyOption[0]);
            return this.outputFile;
        }
        catch (Exception err) {
            throw new OutputWriterException("Unable to copy from input stream to %s.".formatted(this.outputFile), err);
        }
    }
}

