/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.app.module;

import io.github.slimjar.app.module.ModuleExtractor;
import io.github.slimjar.exceptions.ModuleExtractorException;
import io.github.slimjar.exceptions.ModuleNotFoundException;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class TemporaryModuleExtractor
implements ModuleExtractor {
    @Override
    @NotNull
    public URL extractModule(@NotNull URL url, @NotNull String name) throws ModuleExtractorException {
        URL uRL;
        block16: {
            File tempFile = this.createTempFile(name);
            JarURLConnection connection = this.openConnection(url);
            JarFile jarFile = connection.getJarFile();
            try {
                JarEntry module = jarFile.getJarEntry("%s.isolated-jar".formatted(name));
                if (module == null) {
                    throw new ModuleNotFoundException(name);
                }
                try (InputStream stream = jarFile.getInputStream(module);){
                    Files.copy(stream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                uRL = tempFile.toURI().toURL();
                if (jarFile == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ModuleExtractorException("Encountered IOException.", e);
                }
            }
            jarFile.close();
        }
        return uRL;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    private JarURLConnection openConnection(@NotNull URL url) throws ModuleExtractorException {
        try {
            URLConnection connection = url.openConnection();
            return (JarURLConnection)connection;
        }
        catch (IOException err) {
            throw new ModuleExtractorException("Failed to open a connection to url (%s).".formatted(url), err);
        }
        catch (ClassCastException err) {
            throw new ModuleExtractorException("Provided Non-Jar URL (%s).".formatted(url), err);
        }
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    private File createTempFile(@NotNull String name) throws ModuleExtractorException {
        try {
            File tempFile = File.createTempFile(name, ".jar");
            tempFile.deleteOnExit();
            return tempFile;
        }
        catch (IOException | SecurityException err) {
            throw new ModuleExtractorException("Failed to create temporary file", err);
        }
        catch (IllegalArgumentException err) {
            throw new ModuleExtractorException("Module name must be at least 3 characters long", err);
        }
    }
}

