/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.app.builder;

import io.github.slimjar.app.AppendingApplication;
import io.github.slimjar.app.Application;
import io.github.slimjar.app.builder.ApplicationBuilder;
import io.github.slimjar.injector.DependencyInjector;
import io.github.slimjar.injector.loader.Injectable;
import io.github.slimjar.injector.loader.InjectableFactory;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.resolver.ResolutionResult;
import io.github.slimjar.resolver.data.DependencyData;
import io.github.slimjar.resolver.data.Repository;
import io.github.slimjar.resolver.reader.dependency.DependencyDataProvider;
import io.github.slimjar.resolver.reader.resolution.PreResolutionDataProvider;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;

public final class InjectingApplicationBuilder
extends ApplicationBuilder {
    @NotNull
    private final Function<ApplicationBuilder, Injectable> injectableSupplier;

    @Contract(pure=true)
    public InjectingApplicationBuilder(@NotNull String applicationName, @NotNull Injectable injectable) {
        this(applicationName, (ApplicationBuilder it) -> injectable);
    }

    @Contract(pure=true)
    public InjectingApplicationBuilder(@NotNull String applicationName, @NotNull Function<ApplicationBuilder, Injectable> injectableSupplier) {
        super(applicationName);
        this.injectableSupplier = injectableSupplier;
    }

    @Override
    @Contract(value="-> new", mutates="this")
    @NotNull
    public Application buildApplication() {
        DependencyDataProvider dataProvider = this.getDataProviderFactory().create(this.getDependencyFileUrl());
        DependencyData dependencyData = dataProvider.get();
        DependencyInjector dependencyInjector = this.createInjector();
        PreResolutionDataProvider preResolutionDataProvider = this.getPreResolutionDataProviderFactory().create(this.getPreResolutionFileUrl());
        Map<String, ResolutionResult> preResolutionResultMap = preResolutionDataProvider.get();
        dependencyInjector.inject(this.injectableSupplier.apply(this), dependencyData, preResolutionResultMap);
        return new AppendingApplication();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ApplicationBuilder createAppending(@NotNull String applicationName) {
        ClassLoader classLoader = ApplicationBuilder.class.getClassLoader();
        return InjectingApplicationBuilder.createAppending(applicationName, classLoader);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static ApplicationBuilder createAppending(@NotNull String applicationName, @NotNull ClassLoader classLoader) {
        return new InjectingApplicationBuilder(applicationName, builder -> InjectableFactory.create(builder.getDownloadDirectoryPath(), Collections.singleton(Repository.central()), classLoader));
    }
}

