/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.util;

import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.libs.annotations.Nullable;
import java.lang.reflect.Constructor;
import java.util.Arrays;

public final class Reflections {
    private Reflections() {
    }

    @NotNull
    public static Constructor<?> findConstructor(@NotNull Class<?> clazz, Object ... args) throws NoSuchMethodException {
        try {
            return clazz.getConstructor(Reflections.typesFrom(args));
        }
        catch (NoSuchMethodException e) {
            return Arrays.stream(clazz.getConstructors()).filter(c -> Reflections.isConstructorApplicable(c, args)).findFirst().orElseThrow(() -> e);
        }
    }

    public static @Nullable Class<?> @NotNull [] typesFrom(Object ... args) {
        Class[] result = new Class[args.length];
        for (int i2 = 0; i2 < args.length; ++i2) {
            Object current = args[i2];
            result[i2] = current != null ? current.getClass() : Object.class;
        }
        return result;
    }

    private static boolean isConstructorApplicable(@NotNull Constructor<?> constructor, @Nullable Object @NotNull [] args) {
        Class<?>[] params = constructor.getParameterTypes();
        if (!(params.length == args.length || constructor.isVarArgs() && args.length >= params.length - 1)) {
            return false;
        }
        for (int i2 = 0; i2 < params.length; ++i2) {
            Object arg;
            if (constructor.isVarArgs() && i2 == params.length - 1) {
                Class<?> varArgType = params[i2].getComponentType();
                for (int j = i2; j < args.length; ++j) {
                    Object arg2 = args[j];
                    if (arg2 == null || varArgType.isInstance(arg2)) continue;
                    return false;
                }
                return true;
            }
            if (i2 >= args.length || (arg = args[i2]) == null || params[i2].isInstance(arg)) continue;
            return false;
        }
        return true;
    }
}

