/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.util;

import io.github.slimjar.libs.annotations.NotNull;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public final class Connections {
    @NotNull
    private static final String SLIMJAR_USER_AGENT = "SlimjarApplication/* URLDependencyDownloader";

    private Connections() {
    }

    @NotNull
    public static URLConnection createDownloadConnection(@NotNull URL url) throws IOException {
        URLConnection connection = url.openConnection();
        if (!(connection instanceof HttpURLConnection)) {
            return connection;
        }
        HttpURLConnection httpConnection = (HttpURLConnection)connection;
        connection.addRequestProperty("User-Agent", SLIMJAR_USER_AGENT);
        int responseCode = httpConnection.getResponseCode();
        if (responseCode != 200) {
            throw new IOException("Could not download from" + String.valueOf(url));
        }
        return connection;
    }

    public static void tryDisconnect(@NotNull URLConnection urlConnection) {
        if (!(urlConnection instanceof HttpURLConnection)) {
            return;
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
        httpURLConnection.disconnect();
    }
}

