/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver.reader.resolution;

import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.libs.annotations.Nullable;
import io.github.slimjar.resolver.ResolutionResult;
import io.github.slimjar.resolver.reader.resolution.PreResolutionDataProvider;
import io.github.slimjar.resolver.reader.resolution.PreResolutionDataReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Map;

public final class GsonPreResolutionDataProvider
implements PreResolutionDataProvider {
    @NotNull
    private final PreResolutionDataReader resolutionDataReader;
    @NotNull
    private final URL resolutionFileURL;
    private @Nullable Map<@NotNull String, @NotNull ResolutionResult> cachedData = null;

    @Contract(pure=true)
    public GsonPreResolutionDataProvider(@NotNull PreResolutionDataReader resolutionDataReader, @NotNull URL resolutionFileURL) {
        this.resolutionDataReader = resolutionDataReader;
        this.resolutionFileURL = resolutionFileURL;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public @NotNull Map<@NotNull String, @NotNull ResolutionResult> get() {
        Map<String, ResolutionResult> map2;
        block9: {
            if (this.cachedData != null) {
                return this.cachedData;
            }
            InputStream is = this.resolutionFileURL.openStream();
            try {
                map2 = this.cachedData = this.resolutionDataReader.read(is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | ReflectiveOperationException ignored) {
                    return Collections.emptyMap();
                }
            }
            is.close();
        }
        return map2;
    }
}

