/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver.reader.facade;

import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class TypeToken<T> {
    @NotNull
    private final Type rawType = TypeToken.getSuperclassTypeParameter(this.getClass());

    @Contract(pure=true)
    @NotNull
    public Type rawType() {
        return this.rawType;
    }

    @Contract(pure=true)
    @NotNull
    private static Type getSuperclassTypeParameter(@NotNull Class<?> subclass) {
        Type superclass = subclass.getGenericSuperclass();
        if (superclass instanceof Class) {
            throw new RuntimeException("Type parameter not found");
        }
        ParameterizedType parameterized = (ParameterizedType)superclass;
        return parameterized.getActualTypeArguments()[0];
    }
}

