/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver.reader.facade;

import io.github.slimjar.app.builder.ApplicationBuilder;
import io.github.slimjar.exceptions.ResolutionException;
import io.github.slimjar.injector.loader.InjectableClassLoader;
import io.github.slimjar.injector.loader.IsolatedInjectableClassLoader;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.relocation.PassthroughRelocator;
import io.github.slimjar.resolver.data.Dependency;
import io.github.slimjar.resolver.data.DependencyData;
import io.github.slimjar.resolver.data.Repository;
import io.github.slimjar.resolver.reader.facade.GsonFacade;
import io.github.slimjar.resolver.reader.facade.GsonFacadeFactory;
import io.github.slimjar.resolver.reader.facade.ReflectiveGsonFacade;
import io.github.slimjar.util.Packages;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;

public final class ReflectiveGsonFacadeFactory
implements GsonFacadeFactory {
    @NotNull
    private static final String GSON_PACKAGE = "com#google#gson#Gson";
    @NotNull
    private static final String GSON_TYPES_PACKAGE = "com#google#gson#internal#$Gson$Types";
    @NotNull
    private final Constructor<?> gsonConstructor;
    @NotNull
    private final Method gsonFromJsonMethod;
    @NotNull
    private final Method gsonFromJsonTypeMethod;
    @NotNull
    private final Method canonicalizeMethod;

    private ReflectiveGsonFacadeFactory(@NotNull Constructor<?> gsonConstructor, @NotNull Method gsonFromJsonMethod, @NotNull Method gsonFromJsonTypeMethod, @NotNull Method canonicalizeMethod) {
        this.gsonConstructor = gsonConstructor;
        this.gsonFromJsonMethod = gsonFromJsonMethod;
        this.gsonFromJsonTypeMethod = gsonFromJsonTypeMethod;
        this.canonicalizeMethod = canonicalizeMethod;
    }

    @Override
    @Contract(value="-> new")
    @NotNull
    public GsonFacade createFacade() throws ReflectiveOperationException {
        Object gson = this.gsonConstructor.newInstance(new Object[0]);
        return new ReflectiveGsonFacade(gson, this.gsonFromJsonMethod, this.gsonFromJsonTypeMethod, this.canonicalizeMethod);
    }

    @NotNull
    public static GsonFacadeFactory create(@NotNull Path downloadPath, @NotNull Collection<Repository> repositories) throws ResolutionException {
        IsolatedInjectableClassLoader classLoader = new IsolatedInjectableClassLoader();
        return ReflectiveGsonFacadeFactory.create(downloadPath, repositories, classLoader);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static GsonFacadeFactory create(Path downloadPath, Collection<Repository> repositories, InjectableClassLoader classLoader) throws ResolutionException {
        Method canonicalizeMethod;
        Method gsonFromJsonTypeMethod;
        Method gsonFromJsonMethod;
        Constructor<?> gsonConstructor;
        ApplicationBuilder.injecting("SlimJar", classLoader).downloadDirectoryPath(downloadPath).dataProviderFactory(url -> () -> ReflectiveGsonFacadeFactory.getGsonDependency(repositories)).relocatorFactory(rules -> new PassthroughRelocator()).preResolutionDataProviderFactory(a -> Collections::emptyMap).relocationHelperFactory(relocator -> (dependency, file) -> file).build();
        try {
            Class<?> gsonClass = Class.forName(Packages.fix(GSON_PACKAGE), true, classLoader);
            gsonConstructor = gsonClass.getConstructor(new Class[0]);
            gsonFromJsonMethod = gsonClass.getMethod("fromJson", Reader.class, Class.class);
            gsonFromJsonTypeMethod = gsonClass.getMethod("fromJson", Reader.class, Type.class);
            Class<?> gsonTypesClass = Class.forName(Packages.fix(GSON_TYPES_PACKAGE), true, classLoader);
            canonicalizeMethod = gsonTypesClass.getMethod("canonicalize", Type.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException err) {
            throw new ResolutionException("Unable to create gsonFacadeFactory.", err);
        }
        return new ReflectiveGsonFacadeFactory(gsonConstructor, gsonFromJsonMethod, gsonFromJsonTypeMethod, canonicalizeMethod);
    }

    private static DependencyData getGsonDependency(Collection<Repository> repositories) {
        Dependency gson = new Dependency(Packages.fix("com#google#code#gson"), "gson", "2.8.6", null, Collections.emptyList());
        return new DependencyData(Collections.emptySet(), repositories, Collections.singleton(gson), Collections.emptyList());
    }
}

