/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver.reader.facade;

import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.resolver.reader.facade.GsonFacade;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public record ReflectiveGsonFacade(@NotNull Object gson, @NotNull Method gsonFromJsonMethod, @NotNull Method gsonFromJsonTypeMethod, @NotNull Method canonicalizeMethod) implements GsonFacade
{
    @Override
    @Contract(pure=true)
    @NotNull
    public <T> T fromJson(@NotNull InputStreamReader reader, @NotNull Class<T> clazz) throws ReflectiveOperationException {
        Object result = this.gsonFromJsonMethod.invoke(this.gson, reader, clazz);
        if (clazz.isAssignableFrom(result.getClass())) {
            return (T)result;
        }
        throw new AssertionError((Object)"Gson returned wrong type!");
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public <T> T fromJson(@NotNull InputStreamReader reader, @NotNull Type rawType) throws ReflectiveOperationException {
        Object canonicalizedType = this.canonicalizeMethod.invoke(null, rawType);
        Object result = this.gsonFromJsonTypeMethod.invoke(this.gson, reader, canonicalizedType);
        return (T)result;
    }
}

