/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver.reader.dependency;

import io.github.slimjar.exceptions.ResolutionException;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.libs.annotations.Nullable;
import io.github.slimjar.resolver.data.DependencyData;
import io.github.slimjar.resolver.reader.dependency.DependencyDataProvider;
import io.github.slimjar.resolver.reader.dependency.DependencyReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public final class URLDependencyDataProvider
implements DependencyDataProvider {
    @NotNull
    private final DependencyReader dependencyReader;
    @NotNull
    private final URL depFileURL;
    @Nullable
    private DependencyData cachedData = null;

    @Contract(pure=true)
    public URLDependencyDataProvider(@NotNull DependencyReader dependencyReader, @NotNull URL depFileURL) {
        this.dependencyReader = dependencyReader;
        this.depFileURL = depFileURL;
    }

    @Contract(pure=true)
    @NotNull
    public DependencyReader getDependencyReader() {
        return this.dependencyReader;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public DependencyData get() {
        DependencyData dependencyData;
        block9: {
            if (this.cachedData != null) {
                return this.cachedData;
            }
            URLConnection connection = this.depFileURL.openConnection();
            connection.setUseCaches(false);
            InputStream is = connection.getInputStream();
            try {
                dependencyData = this.cachedData = this.dependencyReader.read(is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException err) {
                    throw new ResolutionException("Unable to read dependency data.", err);
                }
            }
            is.close();
        }
        return dependencyData;
    }
}

