/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver.reader.dependency;

import io.github.slimjar.exceptions.ResolutionException;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.resolver.data.DependencyData;
import io.github.slimjar.resolver.reader.dependency.DependencyReader;
import io.github.slimjar.resolver.reader.facade.GsonFacade;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public record GsonDependencyReader(@NotNull GsonFacade gsonFacade) implements DependencyReader
{
    @Override
    @Contract(pure=true)
    @NotNull
    public DependencyData read(@NotNull InputStream inputStream) throws ResolutionException {
        DependencyData dependencyData;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        try {
            dependencyData = this.gsonFacade.fromJson(inputStreamReader, DependencyData.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStreamReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ReflectiveOperationException err) {
                throw new ResolutionException("Failed to read dependency data", err);
            }
        }
        inputStreamReader.close();
        return dependencyData;
    }
}

