/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver.reader.dependency;

import io.github.slimjar.exceptions.ResolutionException;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.libs.annotations.Nullable;
import io.github.slimjar.resolver.reader.dependency.DependencyDataProvider;
import io.github.slimjar.resolver.reader.dependency.DependencyDataProviderFactory;
import io.github.slimjar.resolver.reader.dependency.GsonDependencyReader;
import io.github.slimjar.resolver.reader.dependency.URLDependencyDataProvider;
import io.github.slimjar.resolver.reader.facade.GsonFacade;
import io.github.slimjar.resolver.reader.facade.GsonFacadeFactory;
import java.net.URL;
import java.util.Objects;

public final class GsonDependencyDataProviderFactory
implements DependencyDataProviderFactory {
    @NotNull
    private final GsonFacade gsonFacade;

    @Contract(pure=true)
    public GsonDependencyDataProviderFactory(@NotNull GsonFacadeFactory gsonFactory) throws ResolutionException {
        this.gsonFacade = gsonFactory.fromFactory();
    }

    @Override
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public DependencyDataProvider create(@NotNull URL dependencyFileURL) {
        GsonDependencyReader dependencyReader = new GsonDependencyReader(this.gsonFacade);
        return new URLDependencyDataProvider(dependencyReader, dependencyFileURL);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GsonDependencyDataProviderFactory)) {
            return false;
        }
        GsonDependencyDataProviderFactory that = (GsonDependencyDataProviderFactory)obj;
        return Objects.equals(this.gsonFacade, that.gsonFacade);
    }

    public int hashCode() {
        return Objects.hash(this.gsonFacade);
    }

    public String toString() {
        return "GsonDependencyDataProviderFactory[gsonFacade=" + String.valueOf(this.gsonFacade) + "]";
    }
}

