/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver.reader.dependency;

import io.github.slimjar.exceptions.ResolutionException;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.resolver.reader.dependency.DependencyDataProvider;
import io.github.slimjar.resolver.reader.dependency.DependencyDataProviderFactory;
import io.github.slimjar.resolver.reader.dependency.GsonDependencyReader;
import io.github.slimjar.resolver.reader.dependency.ModuleDependencyDataProvider;
import io.github.slimjar.resolver.reader.facade.GsonFacade;
import io.github.slimjar.resolver.reader.facade.GsonFacadeFactory;
import java.net.URL;

public final class ExternalDependencyDataProviderFactory
implements DependencyDataProviderFactory {
    @NotNull
    private final GsonFacade gsonFacade;

    @Contract(pure=true)
    public ExternalDependencyDataProviderFactory(@NotNull GsonFacadeFactory gsonFactory) throws ResolutionException {
        this.gsonFacade = gsonFactory.fromFactory();
    }

    @Override
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public DependencyDataProvider create(@NotNull URL dependencyFileURL) {
        GsonDependencyReader dependencyReader = new GsonDependencyReader(this.gsonFacade);
        return new ModuleDependencyDataProvider(dependencyReader, dependencyFileURL);
    }
}

