/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver.pinger;

import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.logging.LogDispatcher;
import io.github.slimjar.logging.ProcessLogger;
import io.github.slimjar.resolver.pinger.URLPinger;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;

public final class HttpURLPinger
implements URLPinger {
    @NotNull
    private static final ProcessLogger LOGGER = LogDispatcher.getMediatingLogger();
    @NotNull
    private static final String SLIMJAR_USER_AGENT = "SlimjarApplication/* URL Validation Ping";
    @NotNull
    private static final Collection<String> SUPPORTED_PROTOCOLS = Arrays.asList("HTTP", "HTTPS");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ping(@NotNull URL url) {
        String urlStr = url.toString();
        LOGGER.debug("Pinging %s" + urlStr, new Object[0]);
        if (!this.isSupported(url)) {
            LOGGER.error("Unsupported protocol for %s" + urlStr, new Object[0]);
            return false;
        }
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.addRequestProperty("User-Agent", SLIMJAR_USER_AGENT);
            connection.connect();
            boolean responseOk = connection.getResponseCode() == 200;
            LOGGER.debug("Ping %s for %s", responseOk ? "successful" : "failed", urlStr);
            boolean bl = responseOk;
            return bl;
        }
        catch (IOException err) {
            LOGGER.error("Ping failed for %s" + urlStr, new Object[0]);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return false;
    }

    @Override
    public boolean isSupported(@NotNull URL url) {
        String protocol = url.getProtocol().toUpperCase(Locale.ENGLISH);
        return SUPPORTED_PROTOCOLS.contains(protocol);
    }
}

