/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver.mirrors;

import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.resolver.data.Mirror;
import io.github.slimjar.resolver.data.Repository;
import io.github.slimjar.resolver.mirrors.MirrorSelector;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public final class SimpleMirrorSelector
implements MirrorSelector {
    @Override
    @Contract(pure=true)
    @NotNull
    public @NotNull Collection<@NotNull Repository> select(@NotNull @NotNull Collection<@NotNull Repository> mainRepositories, @NotNull @NotNull Collection<@NotNull Mirror> mirrors) {
        Set originals = mirrors.stream().map(Mirror::original).collect(Collectors.toSet());
        Set<Repository> resolved = mainRepositories.stream().filter(repo -> !originals.contains(repo.url())).collect(Collectors.toSet());
        Set mirrored = mirrors.stream().map(Mirror::mirroring).map(Repository::new).collect(Collectors.toSet());
        resolved.addAll(mirrored);
        return resolved;
    }
}

