/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver.data;

import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.libs.annotations.Nullable;
import io.github.slimjar.relocation.RelocationRule;
import io.github.slimjar.resolver.data.Dependency;
import io.github.slimjar.resolver.data.Mirror;
import io.github.slimjar.resolver.data.Repository;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public record DependencyData(@NotNull Collection<Mirror> mirrors, @NotNull Collection<Repository> repositories, @NotNull Collection<Dependency> dependencies, @NotNull Collection<RelocationRule> relocations) {
    @Contract(pure=true)
    public DependencyData(@NotNull Collection<Mirror> mirrors, @NotNull Collection<Repository> repositories, @NotNull Collection<Dependency> dependencies, @NotNull Collection<RelocationRule> relocations) {
        this.mirrors = Collections.unmodifiableCollection(mirrors);
        this.repositories = Collections.unmodifiableCollection(repositories);
        this.dependencies = Collections.unmodifiableCollection(dependencies);
        this.relocations = Collections.unmodifiableCollection(relocations);
    }

    @Override
    @Contract(value="null -> false", pure=true)
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DependencyData)) {
            return false;
        }
        DependencyData dependencyData = (DependencyData)o;
        return this.isCollectionEqual(this.repositories, dependencyData.repositories) && this.isCollectionEqual(this.dependencies, dependencyData.dependencies) && this.isCollectionEqual(this.relocations, dependencyData.relocations);
    }

    @Contract(pure=true)
    private <T> boolean isCollectionEqual(@NotNull Collection<T> collectionA, @NotNull Collection<T> collectionB) {
        return collectionA.containsAll(collectionB) && collectionB.containsAll(collectionA);
    }

    @Override
    @Contract(pure=true)
    public int hashCode() {
        return Objects.hash(this.repositories, this.dependencies, this.relocations);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public String toString() {
        return "DependencyData{mirrors=" + String.valueOf(this.mirrors) + ", repositories=" + String.valueOf(this.repositories) + ", dependencies=" + String.valueOf(this.dependencies) + ", relocations=" + String.valueOf(this.relocations) + "}";
    }
}

