/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.resolver.data;

import io.github.slimjar.exceptions.NotComparableDependencyException;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.libs.annotations.Nullable;
import java.util.Collection;
import java.util.Objects;

public record Dependency(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @Nullable String snapshotId, @NotNull Collection<Dependency> transitive) implements Comparable<Dependency>
{
    @Override
    @Contract(pure=true)
    @NotNull
    public String toString() {
        String snapshotId = this.snapshotId();
        String suffix = snapshotId != null && snapshotId.length() > 0 ? ":" + snapshotId : "";
        return this.groupId() + ":" + this.artifactId() + ":" + this.version() + suffix;
    }

    @Override
    @Contract(value="null -> false", pure=true)
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Dependency)) {
            return false;
        }
        Dependency otherDependency = (Dependency)o;
        return this.groupId.equals(otherDependency.groupId) && this.artifactId.equals(otherDependency.artifactId) && this.version.equals(otherDependency.version);
    }

    @Override
    @Contract(pure=true)
    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version);
    }

    @Override
    @Contract(pure=true)
    public int compareTo(@NotNull Dependency o) throws NotComparableDependencyException {
        if (!this.equals(o)) {
            throw new NotComparableDependencyException(this, o);
        }
        return this.version().compareTo(o.version());
    }
}

