/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.relocation.meta;

import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.libs.annotations.Nullable;
import io.github.slimjar.relocation.meta.MetaMediator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.UserDefinedFileAttributeView;

public final class AttributeMetaMediator
implements MetaMediator {
    @NotNull
    private final UserDefinedFileAttributeView view;

    public AttributeMetaMediator(@NotNull Path path) {
        this.view = Files.getFileAttributeView(path, UserDefinedFileAttributeView.class, new LinkOption[0]);
    }

    @Override
    @Nullable
    public String readAttribute(@NotNull String name) {
        try {
            ByteBuffer buf = ByteBuffer.allocate(this.view.size(name));
            this.view.read(name, buf);
            buf.flip();
            return Charset.defaultCharset().decode(buf).toString();
        }
        catch (IOException ignored) {
            return null;
        }
    }

    @Override
    public void writeAttribute(@NotNull String name, @NotNull String value) {
        try {
            this.view.write(name, Charset.defaultCharset().encode(value));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

