/*
 * Decompiled with CFR 0.152.
 */
package io.github.slimjar.relocation.facade;

import io.github.slimjar.app.builder.ApplicationBuilder;
import io.github.slimjar.exceptions.RelocatorException;
import io.github.slimjar.injector.loader.InjectableClassLoader;
import io.github.slimjar.injector.loader.IsolatedInjectableClassLoader;
import io.github.slimjar.libs.annotations.Contract;
import io.github.slimjar.libs.annotations.NotNull;
import io.github.slimjar.libs.annotations.Nullable;
import io.github.slimjar.relocation.PassthroughRelocator;
import io.github.slimjar.relocation.RelocationRule;
import io.github.slimjar.relocation.facade.JarRelocatorFacade;
import io.github.slimjar.relocation.facade.JarRelocatorFacadeFactory;
import io.github.slimjar.relocation.facade.ReflectiveJarRelocatorFacade;
import io.github.slimjar.resolver.data.Dependency;
import io.github.slimjar.resolver.data.DependencyData;
import io.github.slimjar.resolver.data.Repository;
import io.github.slimjar.util.Packages;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class ReflectiveJarRelocatorFacadeFactory
implements JarRelocatorFacadeFactory {
    @NotNull
    private static final String JAR_RELOCATOR_PACKAGE = "me#lucko#jarrelocator#JarRelocator";
    @NotNull
    private static final String RELOCATION_PACKAGE = "me#lucko#jarrelocator#Relocation";
    @NotNull
    private final Constructor<?> jarRelocatorConstructor;
    @NotNull
    private final Constructor<?> relocationConstructor;
    @NotNull
    private final Method jarRelocatorRunMethod;

    private ReflectiveJarRelocatorFacadeFactory(@NotNull Constructor<?> jarRelocatorConstructor, @NotNull Constructor<?> relocationConstructor, @NotNull Method jarRelocatorRunMethod) {
        this.jarRelocatorConstructor = jarRelocatorConstructor;
        this.relocationConstructor = relocationConstructor;
        this.jarRelocatorRunMethod = jarRelocatorRunMethod;
    }

    @Override
    @NotNull
    public JarRelocatorFacade createFacade(@NotNull File input, @NotNull File output, @NotNull Collection<RelocationRule> relocationRules) {
        Object relocator;
        try {
            Set<Object> relocations = relocationRules.stream().map(rule -> ReflectiveJarRelocatorFacadeFactory.createRelocation(this.relocationConstructor, rule)).filter(Objects::nonNull).collect(Collectors.toSet());
            relocator = ReflectiveJarRelocatorFacadeFactory.createRelocator(this.jarRelocatorConstructor, input, output, relocations);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException err) {
            throw new RelocatorException("Failed to create JarRelocator", err);
        }
        return new ReflectiveJarRelocatorFacade(relocator, this.jarRelocatorRunMethod);
    }

    @Nullable
    private static Object createRelocation(@NotNull Constructor<?> relocationConstructor, @NotNull RelocationRule rule) {
        try {
            return relocationConstructor.newInstance(rule.originalPackagePattern(), rule.relocatedPackagePattern(), rule.exclusions(), rule.inclusions());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            return null;
        }
    }

    private static Object createRelocator(Constructor<?> jarRelocatorConstructor, File input, File output, Collection<Object> rules) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        return jarRelocatorConstructor.newInstance(input, output, rules);
    }

    private static DependencyData getJarRelocatorDependency(Collection<Repository> repositories) {
        Dependency asm = new Dependency(Packages.fix("org#ow2#asm"), "asm", "9.1", null, Collections.emptyList());
        Dependency asmCommons = new Dependency(Packages.fix("org#ow2#asm"), "asm-commons", "9.1", null, Collections.emptyList());
        Dependency jarRelocator = new Dependency(Packages.fix("me#lucko"), "jar-relocator", "1.6", null, Arrays.asList(asm, asmCommons));
        return new DependencyData(Collections.emptySet(), repositories, Collections.singleton(jarRelocator), Collections.emptyList());
    }

    public static JarRelocatorFacadeFactory create(Path downloadPath, Collection<Repository> repositories) throws RelocatorException {
        IsolatedInjectableClassLoader classLoader = new IsolatedInjectableClassLoader();
        return ReflectiveJarRelocatorFacadeFactory.create(downloadPath, repositories, classLoader);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static JarRelocatorFacadeFactory create(@NotNull Path downloadPath, @NotNull Collection<Repository> repositories, @NotNull InjectableClassLoader classLoader) throws RelocatorException {
        Method runMethod;
        Constructor<?> relocationConstructor;
        Constructor<?> jarRelocatorConstructor;
        ApplicationBuilder.injecting("SlimJar", classLoader).downloadDirectoryPath(downloadPath).preResolutionDataProviderFactory(a -> Collections::emptyMap).dataProviderFactory(url -> () -> ReflectiveJarRelocatorFacadeFactory.getJarRelocatorDependency(repositories)).relocatorFactory(rules -> new PassthroughRelocator()).relocationHelperFactory(relocator -> (dependency, file) -> file).build();
        try {
            Class<?> jarRelocatorClass = Class.forName(Packages.fix(JAR_RELOCATOR_PACKAGE), true, classLoader);
            Class<?> relocationClass = Class.forName(Packages.fix(RELOCATION_PACKAGE), true, classLoader);
            jarRelocatorConstructor = jarRelocatorClass.getConstructor(File.class, File.class, Collection.class);
            relocationConstructor = relocationClass.getConstructor(String.class, String.class, Collection.class, Collection.class);
            runMethod = jarRelocatorClass.getMethod("run", new Class[0]);
        }
        catch (NoSuchMethodException err) {
            throw new RelocatorException("Failed to find JarRelocator constructor", err);
        }
        catch (ClassNotFoundException err) {
            throw new RelocatorException("Failed to find JarRelocator class", err);
        }
        return new ReflectiveJarRelocatorFacadeFactory(jarRelocatorConstructor, relocationConstructor, runMethod);
    }
}

